/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability.data;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import fuzs.puzzleslib.capability.CapabilityController;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.CapabilityKey;
import fuzs.puzzleslib.capability.data.ComponentHolder;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FabricCapabilityKey<C extends CapabilityComponent>
implements CapabilityKey<C> {
    private final ComponentKey<ComponentHolder> capability;
    private final Class<C> componentClass;

    public FabricCapabilityKey(ComponentKey<ComponentHolder> capability, Class<C> componentClass) {
        this.capability = capability;
        this.componentClass = componentClass;
        CapabilityController.submit(this);
    }

    @Override
    public class_2960 getId() {
        return this.capability.getId();
    }

    @Override
    public Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Override
    @Nullable
    public <V> C get(@Nullable V provider) {
        if (provider == null) {
            return null;
        }
        ComponentHolder holder = (ComponentHolder)this.capability.getNullable(provider);
        if (holder == null) {
            return null;
        }
        return (C)holder.component();
    }

    @Override
    public <V> Optional<C> maybeGet(@Nullable V provider) {
        return this.capability.maybeGet(provider).map(holder -> holder.component());
    }

    public static interface FabricCapabilityKeyFactory<C extends CapabilityComponent, T extends CapabilityKey<C>> {
        public T apply(ComponentKey<ComponentHolder> var1, Class<C> var2);
    }
}

